/*
	File: CEG_server.sqf
	Version: 1.1
	Author: Loyalguard

	Description:
	A script to initialize all the required server-side components of the CEG simulation.

	Parameters:
	None.
	
	Execution:
	Executed from CEG_init.sqf.  Will only run in SP, on a MP host, or on a MP dedicated server due to conditions checked in CEG_init.sqf.
*/

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_server.sqf: Thread started."] call LGD_fnc_debugMessage;}; //DEBUG

// Scope //
private ["_side", "_group", "_obj", "_pos", "_class", "_logic", "_inStr", "_outStr", "_onStr", "_supplies"];

// Create a side and group for subsequent game logics.
_side = createCenter sideLogic;
_group = createGroup sideLogic;

// Begin a forEach loop to initialize components of the CEG Simulation.
{ 
	// Assign local variables to elements extracted from the CEG_objects array in this iteration of the forEach loop.
	_obj = (_x select 0); // "objectName_location".
	_pos = (_x select 1); // [Object Position].
	_class = (_x select 2); // "ClassName" of object.
	_effect = (_x select 4); // Effect (sound or particles) associated with object.
	_supplies = (_x select 5); // Other objects/nodes that this object supplies power to.
	
	// Create a game logic used to locate and identify CEG objects and emit sounds as required.  Give it a name unique to its assigned object and position it at the object's exact position.
	"Logic" createUnit [_pos, _group, (format ["CEG_logic_%1 = this; this setPos [%2, %3, %4];", _obj, (_pos select 0), (_pos select 1), (_pos select 2)])];
	
	// Create two game logics specifically to emit effect sounds as required.  Give them names unique to their assigned object and position them at the object's exact position.
	"Logic" createUnit [_pos, _group, (format ["CEG_sound_1_%1 = this; this setPos [%2, %3, %4];", _obj, (_pos select 0), (_pos select 1), (_pos select 2)])];
	
	"Logic" createUnit [_pos, _group, (format ["CEG_sound_2_%1 = this; this setPos [%2, %3, %4];", _obj, (_pos select 0), (_pos select 1), (_pos select 2)])];

	// Create a public variable (integer) to store the % of power flowing into the CEG object.
	_inStr = format ["CEG_in_%1", _obj];
	missionNameSpace setVariable [_inStr, 1];
	publicVariable _inStr;
	
	// Create a public variable (boolean) to indicate if  power is flowing out of the CEG object.
	_outStr = format ["CEG_out_%1", _obj];
	missionNameSpace setVariable [_outStr, true];
	publicVariable _outStr;
	
	// Create a public variable (boolean) to indicate if  power is "on" for this CEG object.
	_onStr = format ["CEG_on_%1", _obj];
	missionNameSpace setVariable [_onStr, true];
	publicVariable _onStr;
		
	// Store a pointer to the primary logic for this object  in a local variable to pass to CEG_monitor.sqf.
	_logic = missionNameSpace getVariable (format ["CEG_logic_%1", _obj]);
	
	// Set a variable to the logic indicating that it is operational.
	_logic setVariable ["operational", true];
	
	// Execute a new instance of CEG_monitor.sqf for this object passing to it the class of the object, the pertinent logic, and the object string, other objects/nodes that this object supplies power to.
	[_class, _logic , _obj, _supplies] execVM "CEG\Scripts\CEG_monitor.sqf";
			
	sleep .01;
	
 } forEach CEG_objects; // CEG_objects was initialized in CEG_init.sqf.
 
 // Initialize a function use to adjust incoming power values that is called/spawned later by CEG_monitor.sqf.
 _nul = execVM "CEG\Functions\CEG_fnc_supply.sqf";

// Execute the script CEG_common.sqf which has common code for required for SP, MP hosts, and MP clients but NOT required for MP dedicated servers.
if (!isDedicated) then
{
	_nul = [] execVM "CEG\Scripts\CEG_common.sqf"; 
};

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_server.sqf: Thread finished."] call LGD_fnc_debugMessage;}; //DEBUG